###  1. Evolution of Network Security

- **Traditional Approach**:
    - Focused on protecting the network perimeter ("keeping the bad guys out").
- **Modern Challenges**:
    - Move from BYOD (Bring Your Own Device) to BYOA (Bring Your Own Application).
    - Employees access corporate data from anywhere, on any device.
    - SaaS vendors offer built-in security, but can't cover all risks from user behavior.
    - Limited visibility into user activity off-network or on unmanaged devices.
    - Threat actors increasingly target cloud-connected users, data, and apps.

---

### 2. The User as a Critical Control Point

- **Shift in Control Points**:
    - User behavior is now a major factor in security.
    - Rapid detection and response to abnormal user activity is essential.
    - Necessary to address increasing threats like ransomware.

---

### 3. Three Broad Security Response Categories

- **Harden and Secure Infrastructure**:
    - Proactively strengthen defenses against emerging threats.
- **Recognize, React, Remove**:
    - Detect, respond to, and eliminate threats confidently.
- **Learn and Improve**:
    - Analyze incidents to enhance future security measures.

---

### 4. The Attack Continuum: Before, During, After

- **Before an Attack**:
    - Harden both perimeter and internal network segments.
    - Use threat intelligence to baseline normal operations.
    - Implement strong remote access security.
    - Add contextual visibility (user account, device).
- **During an Attack**:
    - Priority 1: Contain the threat.
    - Priority 2: Stop the active attack.
    - Containment is critical to prevent threat spread and exponential remediation efforts.
- **After an Attack**:
    - Remove all traces and latent effects.
    - Investigate the attack’s origin (e.g., USB drives, emails, bad URLs).
    - Use analytics to detect lingering malware.
    - Learn from the incident to prevent recurrence.

---

### 5. Cisco Talos Threat Intelligence

- **Role of Cisco Talos**:
    - Provides threat protection across the attack continuum.
    - Group of leading researchers using advanced systems.
- **Core Areas**:
    - Threat intelligence & interdiction
    - Detection research
    - Engine development
    - Vulnerability research & discovery
    - Open source & education
    - Global outreach
- **Benefits**:
    - Intelligence integrated into every Cisco Security product.
    - Public sharing of threat info (blogs, rules, conferences, white papers).
- **Learn More**:
    - [Talos Intelligence](http://www.talosintelligence.com/)

---

### 6. Integrating Cloud Services Without Compromising Security

- **Understand Security Policies**:
    - Knowing company policies helps articulate requirements for secure cloud adoption.
- **Shared Security Model**:
    - Cloud providers and customers share security responsibilities.

---

### 7. Key Security Domains for Organizations

- **Physical Security**:
    - Cloud adoption expands your physical network footprint.
    - Providers and consumers share responsibility for physical security.
- **Network Infrastructure Security**:
    - Even in the cloud, you must secure your infrastructure.
    - Understand and implement cloud security controls to match on-premise standards.
- **API Security**:
    - APIs are essential for cloud automation and integration.
    - Securing APIs is critical to prevent unauthorized access and data leaks.
- **Application Security**:
    - Cloud access often occurs from unmanaged networks/devices.
    - Users may integrate unauthorized third-party apps, creating new risks.
    - Security must address off-premise, SaaS, and third-party app integrations.

---

### 8. Final Notes

- **Breaking Down Security Tasks**:
    - Securing the network is manageable when broken into specific areas.
- **Consistency Across Environments**:
    - Ensure the same security rigor applies to both cloud and on-premise environments.

---

**Summary:**  
Cisco’s threat-centric approach emphasizes the need for a holistic, intelligence-driven defense that spans **before, during, and after an attack**. With the user as a critical control point and the cloud changing the security landscape, organizations must proactively harden all aspects of their infrastructure, leverage advanced threat intelligence, and ensure that security policies and controls are consistently applied across all domains.